% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vennplot.R
\name{vennplot}
\alias{vennplot}
\title{Draw Venn and Euler diagram in 2D or 3D}
\usage{
vennplot(disjoint.combinations = NULL, vars = NULL, Delta = 0.1,
  ThreeD = FALSE, lambda = NULL, stressWay = c("sum", "combine"),
  delta = 0.01, weight = NULL, expand = NULL, twoWayGenerate = FALSE,
  scaleSearch = c("NelderMead", "lineSearch", "goldenSectionSearch", "BFGS",
  "CG", "L-BFGS-B", "SANN", "Brent"), twoWaySearch = c("lineSearch",
  "NelderMead", "goldenSectionSearch", "BFGS", "CG", "L-BFGS-B", "SANN",
  "Brent"), scaleSeachTolerance = list(value = 1e-05, proportional = FALSE),
  distanceTolerance = list(value = 1e-05, proportional = FALSE),
  lossTolerance = list(ToleranceofLoss = 1e-10, maximumStep = 10, ALPHA =
  0.01, ToleranceofStepsize = 1e-05, proportional = FALSE),
  stressBound = 0.001, maximumStep = 50, planeSize = 50, lower = -Inf,
  upper = Inf, control = list(), hessian = FALSE, mar = rep(1, 4),
  cols = NULL, alpha = 0.3, smooth = FALSE, ...)
}
\arguments{
\item{disjoint.combinations}{Named numeric vector or data.frame where each column should be factor.  See Details.}

\item{vars}{Extract specific variables of data.frame as \code{disjoint.combinations}. If \code{vars = NULL}, all the information of data.frame will be extracted.}

\item{Delta}{The length of step for method "lineSearch" or the initial interval of test points for method "NelderMead".}

\item{ThreeD}{Draw Venn diagram in 3D. See Examples.}

\item{lambda}{It can be \code{NULL} or a numeric vector. If \code{lambda = NULL}, the loss function optimize lambda, else, based on the given lambda, loss function will calculate stress respectively then return the minimum one and corresponding lambdas.}

\item{stressWay}{If data set can be separated into a few groups, there will be two ways to express stress: one is to sum up all the stress (named "sum"; default), the other is to use total TSS divide by total RSS (named "combine").}

\item{delta}{Closeness between groups.}

\item{weight}{The weight of \code{disjoint.combinations}. It should have the same length with \code{disjoint.combinations}.}

\item{expand}{If some balls should not intersect and the code fails to detect it. It is possible to be fixed manually but sacrificing stress.}

\item{twoWayGenerate}{Boolean factor, if false, any missing intersections are set as zero.}

\item{scaleSearch}{Provide multiple methods to optimize scale lambda. The default method is "NelderMead". See Details.}

\item{twoWaySearch}{If two way intersections are missing, multiple methods are available to generate two way intersections. The default method is "lineSearch". See Details.}

\item{scaleSeachTolerance}{A list with tolerance value and boolean factor " proportional". The loop of NelderMead and lineSearch in scaleSearch will end when the difference or  proportional difference matches the tolerance value.}

\item{distanceTolerance}{A list with tolerance value and boolean factor " proportional". The Newton method of finding distance will end when the difference or  proportional difference matches the tolerance value.}

\item{lossTolerance}{A list with ToleranceofLoss, maximumStep, ALPHA, ToleranceofStepsize and boolean factor "proportional". If ALPHA is null, the step size will be searched through Newton method and it will stop when step reaches the maximum step or the difference matches ToleranceofStepsize; else step size will be fixed with ALPHA . The loss will end when the difference or proportional difference or the total loss value matches the "ToleranceofLoss".}

\item{stressBound}{The loop of method NelderMead will stop when stress is beyond the stressBound.}

\item{maximumStep}{The maximum searching step for method NelderMead and Newton method of calculating distance.}

\item{planeSize}{The plane size of calculating disjoint intersections numerically.}

\item{lower}{The lower bound of the interval to be searched for the "goldenSectionSearch" and "L-BFGS-B". See Details.}

\item{upper}{The upper bound of the interval to be searched for the "goldenSectionSearch" and "Brent". See Details.}

\item{control}{A list of control parameters. See Details}

\item{hessian}{Logical. A numerically differentiated Hessian matrix be returned or not. See Details.}

\item{mar}{Plot margins.}

\item{cols}{Color of balls. If \code{NULL}, rainbow color will be set.}

\item{alpha}{Color darkness.}

\item{smooth}{For 3D plot, if true, the balls will be much more smoother. However, based on the high resolution, if the number of balls is too much, when rotating, the new window stumbles.}

\item{...}{Any further graphical parameters to be passed to the \code{plot} function.}
}
\value{
An object of the class \code{vennplot} with following components:
\describe{
  \item{xy}{centres of the balls (columns are (\code{x}, \code{y}) or (\code{x}, \code{y}, \code{z}) coordinates).}
  \item{radius}{radii of the balls.}
  \item{loss}{total loss of \code{vennplot}.}
  \item{stress}{stress value for solution.}
}
}
\description{
Draw Venn and Euler diagram in 2D or 3D
}
\details{
1. One way sets must be given in \code{disjoint.combination}. e.g.\code{disjoint.combination = c( B=2, AB=0.5)} is not allowed.  \code{disjoint.combination = c(A = 0, B=2, AB=0.5)} works.
2. Except "NelderMead" and "lineSearch", "goldenSectionSearch" in \code{scaleSearch} and \code{twoWaySearch} is based on \code{\link{optimize}} and the rest methods are based on \code{\link{optim}}.
3. \code{lower}, \code{upper}, \code{control} and \code{hessian} share the same parameters with \code{\link{optim}}, and \code{lower}, \code{upper} can also be used in \code{\link{optimize}}
}
\examples{
# 3D Venn plot with arbitray sets
disjoint.combinations = c(A=80, B=50,C=100, D = 100,E = 100,
                          "A&C"=30, "A&D"= 30,"B&E" = 30, "A&E" = 40, h = 40, "B&h" = 10)
ve = vennplot(disjoint.combinations, ThreeD = TRUE)

# data frame
vennplot(disjoint.combinations = sharks, vars = c("Au","USA","Fa","Sex"),
         scaleSearch = "lineSearch", expand = 1.1)

}
\author{
Zehao Xu and Wayne Oldford
}
