% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{vetiver_type_convert}
\alias{vetiver_type_convert}
\title{Convert new data at prediction time using input data prototype}
\usage{
vetiver_type_convert(new_data, ptype)
}
\arguments{
\item{new_data}{New data for making predictions, such as a data frame.}

\item{ptype}{An input data prototype, such as a 0-row slice of the training
data}
}
\value{
A converted dataframe
}
\description{
This is a developer-facing function, useful for supporting new model types.
At prediction time, new observations typically must be checked and sometimes
converted to the data types from training time.
}
\examples{

library(tibble)
training_df <- tibble(x = as.Date("2021-01-01") + 0:9,
                      y = LETTERS[1:10], z = letters[11:20])
training_df

prototype <- vctrs::vec_slice(training_df, 0)
vetiver_type_convert(tibble(x = "2021-02-01", y = "J", z = "k"), prototype)

## unsuccessful conversion generates an error:
try(vetiver_type_convert(tibble(x = "potato", y = "J", z = "k"), prototype))

## error for missing column:
try(vetiver_type_convert(tibble(x = "potato", y = "J"), prototype))

}
