% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_tto.R
\name{desc_tto}
\alias{desc_tto}
\title{Time to onset descriptive}
\usage{
desc_tto(.data, adr_s, drug_s, tto_time_range = 1, ...)
}
\arguments{
\item{.data}{A \code{link} data.table. See \code{\link{link_}}.}

\item{adr_s}{A character string. The name of the adr column. (see details)}

\item{drug_s}{A character string. The name of the drug column. (see details)}

\item{tto_time_range}{Incertitude range of Time to onset, in days. Defaults to 1 as recommended by umc}

\item{...}{Additional parameters to be passed to \code{\link[=desc_cont]{desc_cont()}}. E.g. \code{format}, \code{digits}...}
}
\value{
A data.table with one row per drug-adr pair
\itemize{
\item A descriptive of time to onsets for this combination (column \code{tto_max}).
\item It is Median (Quartile 1 - Quartile 3) and min-max by default, change
with \code{format} arg (passed to \code{\link[=desc_cont]{desc_cont()}}).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \code{desc_tto()} provides a
drug-adr pair description of time to onset.
}
\details{
Description of time (maximum available time) between drug initiation
and event onset. This runs at the drug-adr pair level.
Internally, it uses \code{\link[=extract_tto]{extract_tto()}} and \code{\link[=desc_cont]{desc_cont()}},
You will need a \code{link} data.table, see \code{\link{link_}}, on which
you have added drugs and adrs with \code{\link[=add_drug]{add_drug()}} and \code{\link[=add_adr]{add_adr()}}.
you can supply extra arguments to \code{\link[=desc_cont]{desc_cont()}} with \code{...}.
Uppsala Monitoring Centre recommends to use only cases where the incertitude
on time to onset is less than \strong{1 day}. You can change this with \code{tto_time_range}.
}
\examples{
link_ <-
  link_ |>
  add_drug(
    d_code = ex_$d_groups_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )

desc_tto(.data = link_,
         adr_s = "a_colitis",
         drug_s = "pd1")


desc_tto(.data = link_,
         adr_s = c("a_colitis", "a_pneumonitis"),
         drug_s = c("pd1", "ctla4"))
}
\seealso{
\code{\link{link_}}, \code{\link[=extract_tto]{extract_tto()}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}, \code{\link[=desc_dch]{desc_dch()}}, \code{\link[=desc_rch]{desc_rch()}}
}
\keyword{descriptive}
\keyword{drug-adr-pair}
