% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.cm.R
\name{ggplot.cm}
\alias{ggplot.cm}
\title{Create a ggplot Plot from Correlation Coefficients (Deprecated)}
\usage{
\method{ggplot}{cm}(
  data,
  mapping = NULL,
  ...,
  show.stat = TRUE,
  environment = parent.frame()
)
}
\arguments{
\item{data}{A numeric 2D matrix of correlation coefficients. (For 3D arrays, a warning is issued.)}

\item{mapping}{Optional ggplot2 aesthetic mapping.}

\item{...}{Additional arguments passed to \code{ggplot}.}

\item{show.stat}{Logical. If \code{TRUE}, prints the best \eqn{R^2} value and corresponding bands.}

\item{environment}{The environment in which to evaluate the plot. Defaults to \code{parent.frame()}.}
}
\value{
A ggplot object visualizing the correlation matrix. For 3D arrays, returns \code{NULL}.
}
\description{
**Deprecated:** This function is deprecated and will be removed in a future release.
Please use \code{plt.2dcm} for 2D correlation matrices or the appropriate new functions for 3D plots.
}
\details{
This function creates a ggplot visualization from a 2D correlation matrix.
It attempts to extract numeric wavelengths from the column names of the input matrix.

This function extracts numeric wavelengths from the column names of \code{data}. If these
cannot be determined, sequential indices are used instead.
}
\examples{
\dontrun{
  library(visa)
  data(NSpec.DF)
  x <- NSpec.DF$N  # nitrogen
   # resampled to 10 nm steps
  S <- NSpec.DF$spectra[, seq(1, ncol(NSpec.DF$spectra), 10)]
  cm2d <- cm.sr(S, x, cm.plot = FALSE)
  p2d <- ggplot.cm(cm2d)
  print(p2d)

}

}
