% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelength.R
\docType{methods}
\name{wavelength}
\alias{wavelength}
\alias{wavlen}
\alias{wavelength,Spectra-method}
\alias{wavelength,Spectra,ANY-method}
\alias{wavelength,data.frame-method}
\alias{wavelength,data.frame,ANY-method}
\alias{wavelength,matrix-method}
\alias{wavelength,matrix,ANY-method}
\title{Retrieve Wavelength Information from Spectra Objects}
\usage{
wavelength(object, ...)

\S4method{wavelength}{Spectra}(object, ...)

\S4method{wavelength}{data.frame}(object, ...)

\S4method{wavelength}{matrix}(object, ...)
}
\arguments{
\item{object}{An object containing spectra data. This can be an S4 object of class \code{Spectra},
a \code{data.frame}, or a \code{matrix}.}

\item{...}{Additional arguments for future extensions (currently not used).}
}
\value{
A numeric vector representing the wavelength information extracted from the object.
}
\description{
This function extracts the wavelength information from various representations of spectra.
It supports the S4 class \code{Spectra}, as well as data.frame and matrix representations.
}
\details{
For an object of class \code{Spectra}, the method returns the value stored in the \code{wavelength}
slot. For a data.frame or matrix, it extracts numeric values from the column names (by removing
non-digit characters) of the spectra data.
}
\examples{
\dontrun{
  library(visa)

  # For an S4 Spectra object
  wavelengths <- wavelength(NSpec.Lib)

  # For spectra stored in a data.frame
  wavelengths <- wavelength(NSpec.DF)

  # For spectra stored in a matrix
  wavelengths <- wavelength(spectra_matrix)
}

}
