% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stacked_bar_chart.R
\name{stacked_bar_chart}
\alias{stacked_bar_chart}
\title{stacked_bar_chart}
\usage{
stacked_bar_chart(
  data,
  ordinalAccessor,
  valueAccessor,
  groupAccessor,
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{ordinalAccessor}{String. Key used to determine bar's categorical property, within groups. (similar to x in ggplot)}

\item{valueAccessor}{String. Key used to determine bar's numeric property. (similar to y in ggplot)}

\item{groupAccessor}{String. Key used to determine bar clusters.}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/stacked-bar-chart#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/stacked-bar-chart}{@visa/stacked-bar-chart}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/stacked-bar-chart}{@visa/stacked-bar-chart}.}
}
\value{
a visaChart htmlwidget object for plotting a stacked bar chart
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/stacked-bar-chart}{@visa/stacked-bar-chart} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of stacked-bar-chart in action:
\if{html}{\figure{figures/stacked-bar-chart-1.png}{options: width=400 alt="example stacked bar chart"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/stacked-bar-chart}{@visa/stacked-bar-chart}.
}
\examples{
library(dplyr)
data.frame(UCBAdmissions) \%>\%
  filter(Admit == "Rejected") \%>\%
  stacked_bar_chart("Gender", "Freq", "Dept")
}
