% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world_map.R
\name{world_map}
\alias{world_map}
\title{world_map}
\usage{
world_map(
  data,
  joinAccessor = "",
  joinNameAccessor = "",
  markerAccessor = "",
  markerNameAccessor = "",
  latitudeAccessor = "",
  longitudeAccessor = "",
  valueAccessor,
  groupAccessor = "",
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{joinAccessor}{String. Key used to determine country's key property (ISO 3-Digit Code).}

\item{joinNameAccessor}{String. Key used to determine country's name property.}

\item{markerAccessor}{String. Key used to determine marker's key property.}

\item{markerNameAccessor}{String. Key used to determine marker's name property.}

\item{latitudeAccessor}{String. Key used to determine marker's latitude property.}

\item{longitudeAccessor}{String. Key used to determine marker's longitude property.}

\item{valueAccessor}{String. Key used to determine the country/marker's numeric property.}

\item{groupAccessor}{String. Key used to determine country/marker color.}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/world-map#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/world-map}{@visa/world-map}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/world-map}{@visa/world-map}.}
}
\value{
a visaChart htmlwidget object for plotting a world map
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/world-map}{@visa/world-map} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of world-map in action:
\if{html}{\figure{world-map-1.png}{options: width=400 alt="example world map"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/world-map}{@visa/world-map}.
}
\examples{
library(dplyr)
quakes \%>\%
 sample_n(100) \%>\%
 tibble::rowid_to_column() \%>\%
 world_map(
   markerAccessor = "rowid",
   latitudeAccessor = "long",
   longitudeAccessor = "lat",
   valueAccessor = "stations",
   markerStyle=list(
    visible=TRUE,
    fill=TRUE,
    opacity=.5,
    radiusRange=c(5,15)
   )
 )
}
