% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{groupsSearch}
\alias{groupsSearch}
\title{Returns a list of communities matching the search criteria}
\usage{
groupsSearch(
  q = "",
  type = "",
  country_id = "",
  city_id = "",
  future = 0,
  market = 0,
  sort = 0,
  offset = 0,
  count = 20,
  v = getAPIVersion()
)
}
\arguments{
\item{q}{Search query string}

\item{type}{Community type. Possible values: group, page, event}

\item{country_id}{Country ID}

\item{city_id}{City ID. If this parameter is transmitted, country_id is ignored}

\item{future}{1 — to return only upcoming events. Works with the type = event only}

\item{market}{1 — to return communities with enabled market only}

\item{sort}{Sort order. Possible values:
\itemize{
  \item 0 — default sorting (similar the full version of the site);
  \item 1 — by growth speed;
  \item 2— by the "day attendance/members number" ratio;
  \item 3 — by the "Likes number/members number" ratio;
  \item 4 — by the "comments number/members number" ratio;
  \item 5 — by the "boards entries number/members number" ratio.
}}

\item{offset}{Offset needed to return a specific subset of results}

\item{count}{Number of communities to return (default 20, maximum value 1000)}

\item{v}{Version of API}
}
\description{
Returns a list of communities matching the search criteria
}
