% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEmptyDF.R
\name{createEmptyDF}
\alias{createEmptyDF}
\title{Create an Empty data.frame}
\usage{
createEmptyDF(
  path = ".",
  audioList = list(),
  fileType = "wav",
  fileNamePattern = "ID_Condition_Dimension",
  sep = "_",
  measures = c(),
  jointDimensions = FALSE,
  separateConditions = TRUE,
  filter = NA,
  recursive = FALSE
)
}
\arguments{
\item{path}{An optional character string indicating the path to the folder containing the audio files. Default corresponds to current working directory.}

\item{audioList}{Optional list with already loaded Wave objects to analyze.}

\item{fileType}{Character string indicating the file format (wav or mp3) of the audio files. Default corresponds to wav.}

\item{fileNamePattern}{A character string indicating the naming format, such as "ID-Condition-Dimension", "Condition_ID_Dimension" or "ID". Default corresponds to "ID_Condition_Dimension".}

\item{sep}{A non alpha-numeric character that acts as separator between the different naming components. Default corresponds to underscore. This field can be ignored if the audio file names only contain an ID component.}

\item{measures}{A character vector of measures that should appear in the data frame columns.}

\item{jointDimensions}{Logical value indicating whether dimensions should be joint into a single or not. Default corresponds to FALSE.}

\item{separateConditions}{Logical value indicating whether conditions should be separated or not. Default corresponds to TRUE.}

\item{filter}{Optional character vector indicating IDs, Conditions, Dimensions or other name patterns. Default corresponds to NA.}

\item{recursive}{Logical value indicating whether subdirectories should be included when searching for audio files. Default corresponds to FALSE.}
}
\value{
An empty data.frame in which ID's represent rows and dimensions/measures represent columns.
}
\description{
Internal function which creates an empty data.frame in which the different audio files represent rows and the extracted measures represent columns. Several options can be configured such as joining dimensions or separating conditions.
}
