% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{get_prefix}
\alias{get_prefix}
\title{Get the common prefix of character values}
\usage{
get_prefix(
  x,
  ignore.case = FALSE,
  trim = FALSE,
  delimiters = c(":", "\\n"),
  minlength = 3
)
}
\arguments{
\item{x}{Character vector.}

\item{ignore.case}{Whether case matters (default).}

\item{trim}{Whether non alphabetic characters should be trimmed.}

\item{delimiters}{A list of prefix delimiters.
If any of the delimiters is present in the extracted prefix,
the part after is removed from the prefix.
Consider the following two items as an example:
\code{c("Usage: in private context", "Usage: in work context")}.
The common prefix would be \preformatted{"Usage: in "}, but it makes
more sense to break it after the colon.}

\item{minlength}{Minimum length of the prefix.
Consider the following two items as an example:
\code{c("coder one", "cg_act_write")}.
The common prefix would be \preformatted{"c"},
although the items have nothing in common.
Requirung a minimum common prefix length should help in many cases.}
}
\value{
The longest common prefix of the strings.
}
\description{
Helper function taken from the biobase package.
Duplicated here instead of loading the package to avoid overhead.
See https://github.com/Bioconductor/Biobase
}
\keyword{internal}
