% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.search.mastodon.R
\name{Collect.search.mastodon}
\alias{Collect.search.mastodon}
\title{Collect post data from mastodon search}
\usage{
\method{Collect}{search.mastodon}(
  credential,
  endpoint,
  hashtag = NULL,
  instance = NULL,
  local = FALSE,
  numPosts = 100,
  anonymous = TRUE,
  retryOnRateLimit = TRUE,
  ...,
  writeToFile = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"mastodon"}.}

\item{endpoint}{API endpoint.}

\item{hashtag}{Character string. Specifies a mastodon query to search on e.g #hashtag. Set to \code{NULL} for unfiltered public posts. Default is \code{NULL}.}

\item{instance}{Character string. Server to collect posts from. Default is \code{NULL}.}

\item{local}{Logical. Search the local server or global timeline. \code{FALSE}.}

\item{numPosts}{Numeric. Specifies how many tweets to be collected. Default is \code{100}.}

\item{anonymous}{Logical. Collect public posts without authenticating. Default is \code{TRUE}.}

\item{retryOnRateLimit}{Logical. When the API rate-limit is reached should the collection wait and resume when it resets. Default is \code{TRUE}.}

\item{...}{
  Arguments passed on to \code{\link[rtoot:get_timeline_hashtag]{rtoot::get_timeline_hashtag}}
  \describe{
    \item{\code{only_media}}{logical, Show only statuses with media attached?}
    \item{\code{min_id}}{character or \code{POSIXct} (date time), Return results immediately newer than this id}
  }}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
A tibble object with class names \code{"datasource"} and \code{"mastodon"}.
}
\description{
This function collects posts based on search terms and structures the data into a dataframe with
the class names \code{"datasource"} and \code{"mastodon"}.
}
