% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.web.R
\name{Create.actor.web}
\alias{Create.actor.web}
\title{Create web actor network}
\usage{
\method{Create}{actor.web}(datasource, type, ..., writeToFile = FALSE, verbose = TRUE)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"web"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"activity"}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a web page domain network from pages. Nodes are site domains.
}
\examples{
\dontrun{
# create a web actor network graph
net_activity <- data_collect |> Create("actor")

# network
# net_activity$nodes
# net_activity$edges
}

}
