% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{canvas_authenticate}
\alias{canvas_authenticate}
\title{Authenticate with Canvas LMS API}
\usage{
canvas_authenticate(api_key = canvas_api_key(), base_url = canvas_base_url())
}
\arguments{
\item{api_key}{The API key for authenticating with the Canvas LMS API. Defaults to the \code{CANVAS_API_KEY} environment variable.}

\item{base_url}{The base URL of the Canvas instance. Defaults to the \code{CANVAS_BASE_URL} environment variable.}
}
\value{
A list containing the authenticated 'api_key' and 'base_url'.
}
\description{
This function handles authentication with the Canvas LMS API.
It uses the provided API key and base URL, or falls back to the \code{CANVAS_API_KEY} and \code{CANVAS_BASE_URL} environment variables if none are provided.
}
\note{
The function verifies authentication by making a test request to the \verb{/api/v1/users/self} endpoint of the Canvas instance.
If the response status code is not 200, it throws an error message indicating that authentication failed.
}
\examples{
\dontrun{
# Authenticate with the Canvas LMS API
api_key <- "your_api_key"
base_url <- "https://canvas.example.com"
canvas <- canvas_authenticate(api_key, base_url)
}
}
