% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{Entropy}
\alias{Entropy}
\title{Generalized entropy index}
\usage{
Entropy(X, W = rep(1, length(X)), power = 0.5, zeroes = "include")
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}

\item{power}{is a entropy parameter}

\item{zeroes}{defines what to do with zeroes in the data vector. Possible options are "remove" and "include". See Details for more.}
}
\value{
The value of generalized entropy index
}
\description{
Computes generalized entropy index of a given variable taking into account weights.
}
\details{
Entropy coefficient with respect to parameter \eqn{\alpha} is equal to Theil_L(X,W)  whenever \eqn{\alpha=0},
is equal to Theil_T(X,W) whenever \eqn{\alpha=1}, and whenever \eqn{\alpha \in (0,1)} we have
\deqn{GE(\alpha) = \frac{1}{\alpha(\alpha-1)W}\sum_{i=1}^{n}w_{i}\left(\left(\frac{x_{i}}{\mu}\right)^\alpha-1\right)}
where \eqn{W} is a sum of weights and \eqn{\mu} is the arithmetic mean of \eqn{x_{1},...,x_{n}}.
Entropy coefficient is not well-defined for data vector with zero values whenever parameter is zero or one.
In such case, entropy index coincides with the definition of Theil L index and Theil T index, respectively, and entropy index is calculated with corresponding Theil function.
Theil L always removes zeroes. Theil T enables two ways to deal with zeroes by parameter zeroes.
Option "remove" discard these X's and corresponding weights. Works for power>0.
Option "include" puts \eqn{0\log{0=}0} due to limiting property of \eqn{p\log{p}} in zero preserving zero value in dataset. It is valid only for Theil T index, that is power=0.
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
Entropy(X)
Entropy(X,W)

data(Tourism)
# Generalized entropy index for Total expenditure with sample weights
X=Tourism$Total_expenditure
W=Tourism$Sample_weight
Entropy(X,W)


}
\references{
Shorrocks A. F.: (1980) The Class of Additively Decomposable Inequality Measures. Econometrica

Pielou E.C.: (1966) The measurement of diversity in different types of biological collections. Journal of Theoretical Biology
}
