% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_wal.R
\name{plotwal.rawdata}
\alias{plotwal.rawdata}
\title{Plot raw pixel index data as image.}
\usage{
plotwal.rawdata(raw_data, width, height, apply_palette = wal::pal_q2())
}
\arguments{
\item{raw_data}{integer vector in containing width * height values in range 0..255, and optionally additional mipmap data at the end (which will be ignored). The raw image data. Can be a Q2 WAL data,  Q1 miptex data, or anything else.}

\item{width}{positive integer, the image width.}

\item{height}{positive integer, the image height.}

\item{apply_palette}{optional 256 x 3 integer matrix, the palette. Must contain values in range 0..255. Pass NULL if you do not want to apply any palette. The resulting \code{wal} object will not have an 'image' entry then.}
}
\description{
Plot raw pixel index data as image.
}
\examples{
\dontrun{
# Plot the Q1 shambler skin:
mdl = read.quake.mdl("~/data/q1_pak/progs/shambler.mdl");
plotwal.rawdata(mdl$skins$skin_pic, mdl$header$skin_width,
 mdl$header$skin_height, apply_palette = pal_q1());
}

}
