#' Create Dummy Variables
#'
#' Create dummy variables of factors and character vectors in a data frame
#'
#' @param input data.frame with calibration variables
#' @param vars character vector with names of variables requiring dummy encoding
#'
#' @return data.frame with the new dummy variables
#' 
#' @examples
#' calVars <- c(
#'   "SEX_A_R", "AGEP_A_R", "HISPALLP_A_R", "ORIENT_A_R", "HICOV_A_R", "EDUCP_A_R", "REGION_R",
#'   "EMPLASTWK_A_R", "HOUTENURE_A_R", "MARITAL_A_R"
#' )
#' stuVars <- "DIBTYPE_A_R"
#' nhis_keep_vars <- c("PPSU","PSTRAT","WTFA_A")
#' 
#' # First impute
#' nhis_imputed <- impute_data(nhis_processed, c(calVars, stuVars), nhis_keep_vars)
#' 
#' # Then create dummy variables
#' nhis_vars_dummies <- c("AGEP_A_R","HISPALLP_A_R","EDUCP_A_R","REGION_R")
#' nhis_dummied <- dummies(nhis_imputed, vars=paste0(nhis_vars_dummies, '_I'))
#' 
#' @importFrom stats model.matrix contrasts
#' @export
dummies <- function(input, vars) {
  
  # Create new names for vars_dummies that use the imputed values
  vars_dummies <- vars
  
  dummies <- model.matrix(
    ~ . - 1,
    data = input[vars_dummies],
    contrasts.arg = lapply(input[vars_dummies], function(x)
      if (is.factor(x)) contrasts(x, contrasts = FALSE) else NULL)
  )
  
    # Combine dummy variables with original dataset
    final <- cbind(input, dummies)

    return(final)
}
