% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{washi_pal_view}
\alias{washi_pal_view}
\title{View a WaSHI palette}
\usage{
washi_pal_view(palette = "color_blind", n, reverse = FALSE)
}
\arguments{
\item{palette}{Character name of palette in washi_pal. See
\code{names(washi_pal)} for a list of available palettes.}

\item{n}{Number of colors in palette.}

\item{reverse}{Boolean indicating whether the palette should be
reversed. Default is FALSE.}
}
\value{
A plot with each color displayed.
}
\description{
Show the colors within a palette in a plot.
}
\examples{
washi_pal_view("standard")

washi_pal_view("color_blind")

washi_pal_view("blue_gradient", 4, reverse = TRUE)
}
\seealso{
Other color palette functions: 
\code{\link{washi_pal}},
\code{\link{washi_pal_setup}()}
}
\concept{color palette functions}
