% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretreat_spectra.R
\name{pretreat_spectra}
\alias{pretreat_spectra}
\title{Pretreat spectral data according to user-designated method}
\usage{
pretreat_spectra(
  df,
  test.data = NULL,
  pretreatment = 1,
  preprocessing.method = deprecated(),
  wavelengths = deprecated()
)
}
\arguments{
\item{df}{\code{data.frame} object containing spectral data. First column(s)
(optional) include metadata (with or without reference value column)
followed by spectral columns. Spectral column names must be formatted as
"X" followed by wavelength Include no other columns to right of spectra! No
missing values permitted.}

\item{test.data}{\code{data.frame} object with same format as train.data.
Will be appended to \code{df} during pretreatment so that the same
transformations are applied to each row. Default is \code{NULL}.}

\item{pretreatment}{Number or list of numbers 1:13 corresponding to
  desired pretreatment method(s):
\enumerate{
  \item Raw data (default)
  \item Standard normal variate (SNV)
  \item SNV and first derivative
  \item SNV and second derivative
  \item First derivative
  \item Second derivative
  \item Savitzky–Golay filter (SG)
  \item SNV and SG
  \item Gap-segment derivative (window size = 11)
  \item SG and first derivative (window size = 5)
  \item SG and first derivative (window size = 11)
  \item SG and second derivative (window size = 5)
  \item SG and second derivative (window size = 11)
}}

\item{preprocessing.method}{DEPRECATED \code{preprocessing.method}
has been renamed "pretreatment"}

\item{wavelengths}{DEPRECATED \code{wavelengths} is no
longer supported; this information is now inferred from \code{df}
column names}
}
\value{
Pretreated \code{df}` (or list of \code{data.frame}s) with
  reference column intact
}
\description{
Pretreatment, also known as preprocessing, is often used to
  increase the signal to noise ratio in vis-NIR datasets. The \emph{waves}
  function \code{pretreat_spectra} applies common spectral pretreatment
  methods such as standard normal variate and the Savitzky-Golay filter.
}
\examples{
pretreat_spectra(df = ikeogu.2017, pretreatment = 3)[1:5, 1:5]
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
