% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unweightedinteractionweatherindices.R
\name{i.uwwi}
\alias{i.uwwi}
\title{Un-weighted Interaction Weather Indices}
\usage{
i.uwwi(y, weatherp1, weatherp2)
}
\arguments{
\item{y}{A vector of yearly yield data for t years}

\item{weatherp1}{Weekly weather data for t years as vector of first weather variable(total observations= number of years*number of weeks in each year)}

\item{weatherp2}{Weekly weather data for t years as vector of second weather variable(total observations= number of years*number of weeks in each year)}
}
\value{
A vector of interaction weather indices
}
\description{
Converts the weekly interaction of two weather variable into yearly weighted interaction weather indices
}
\examples{
data(Burdwanweather) #Weekly weather data for the rice growing season in Burdwan
data(Burdwanriceyield) #Yearly Yield data of rice  in Burdwan
i.uwwi.maxmintem<-i.uwwi(Burdwanriceyield$burdwan,Burdwanweather$Max.Temperature,
                         Burdwanweather$Min.Temperature)
i.uwwi.maxmintem
}
\references{
Jain, R. C., Agrawal, R., & Jha, M. P. (1980). Effect of climatic variables on rice yield and its forecast. MAUSAM, 31(4), 591-596.
}
