% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stub_request.R
\name{stub_request}
\alias{stub_request}
\title{Stub an http request}
\usage{
stub_request(method = "get", uri = NULL, uri_regex = NULL)
}
\arguments{
\item{method}{(character) HTTP method, one of "get", "post", "put", "patch",
"head", "delete", "options" - or the special "any" (for any method)}

\item{uri}{(character) The request uri. Can be a full or partial uri.
\pkg{webmockr} can match uri's without the "http" scheme, but does
not match if the scheme is "https". required, unless \code{uri_regex} given.
See \link{UriPattern} for more. See the "uri vs. uri_regex" section}

\item{uri_regex}{(character) A URI represented as regex. required, if \code{uri}
not given. See examples and the "uri vs. uri_regex" section}
}
\value{
an object of class \code{StubbedRequest}, with print method describing
the stub.
}
\description{
Stub an http request
}
\details{
Internally, this calls \link{StubbedRequest} which handles the logic

See \code{\link[=stub_registry]{stub_registry()}} for listing stubs, \code{\link[=stub_registry_clear]{stub_registry_clear()}}
for removing all stubs and \code{\link[=remove_request_stub]{remove_request_stub()}} for removing specific
stubs

If multiple stubs match the same request, we use the first stub. So if you
want to use a stub that was created after an earlier one that matches,
remove the earlier one(s).

Note on \code{wi_th()}: If you pass \code{query}, values are coerced to character
class in the recorded stub. You can pass numeric, integer, etc., but
all will be coerced to character.

See \code{\link[=wi_th]{wi_th()}} for details on request body/query/headers and
\code{\link[=to_return]{to_return()}} for details on how response status/body/headers
are handled
}
\note{
Trailing slashes are dropped from stub URIs before matching
}
\section{uri vs. uri_regex}{

When you use \code{uri}, we compare the URIs without query params AND
also the query params themselves without the URIs.

When you use \code{uri_regex} we don't compare URIs and query params;
we just use your regex string defined in \code{uri_regex} as the pattern
for a call to \link{grepl}
}

\section{Mocking writing to disk}{

See \link{mocking-disk-writing}
}

\section{Error handling}{

To construct stubs, one uses \code{\link[=stub_request]{stub_request()}} first - which registers
the stub in the stub registry. Any additional calls to modify the stub
with for example \code{\link[=wi_th]{wi_th()}} or \code{\link[=to_return]{to_return()}} can error. In those error
cases we ideally want to remove (unregister) the stub because you
certainly don't want a registered stub that is not exactly what you
intended.

When you encounter an error creating a stub you should see a warning
message that the stub has been removed, for example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{stub_request("get", "https://httpbin.org/get") \%>\%
  wi_th(query = mtcars)
#> Error in `wi_th()`:
#> ! z$query must be of class list or partial
#> Run `rlang::last_trace()` to see where the error occurred.
#> Warning message:
#> Encountered an error constructing stub
#> • Removed stub
#> • To see a list of stubs run stub_registry()
}\if{html}{\out{</div>}}
}

\examples{
# basic stubbing
stub_request("get", "https://httpbin.org/get")
stub_request("post", "https://httpbin.org/post")

# any method, use "any"
stub_request("any", "https://httpbin.org/get")

# list stubs
stub_registry()

# clear all stubs
stub_registry()
stub_registry_clear()
}
\seealso{
\code{\link[=wi_th]{wi_th()}}, \code{\link[=to_return]{to_return()}}, \code{\link[=to_timeout]{to_timeout()}}, \code{\link[=to_raise]{to_raise()}},
\code{\link[=mock_file]{mock_file()}}
}
