% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_density_layer.R
\name{gg_density_layer}
\alias{gg_density_layer}
\title{Add ggplot layer of densities from distributional objects in 1 dimension}
\usage{
gg_density_layer(object, scale = 1, ngrid = 501, ...)
}
\arguments{
\item{object}{distribution object from the distributional package or
\code{\link{dist_kde}}()}

\item{scale}{Scaling factor for the density function.}

\item{ngrid}{Number of grid points to use for the density function.}

\item{...}{Additional arguments are passed to \code{\link[ggplot2]{geom_line}}.}
}
\value{
A ggplot layer
}
\description{
Add ggplot layer of densities from distributional objects in 1 dimension
}
\details{
This function adds a ggplot layer of a density from a distributional object.
For univariate densities, it adds a line plot of the density function.
For bivariate densities, it adds a contour plot of the density function.
}
\examples{
dist_mixture(
  dist_normal(-2, 1),
  dist_normal(2, 1),
  weights = c(1 / 3, 2 / 3)
) |>
  gg_density() +
  gg_density_layer(dist_normal(-2, 1), linetype = "dashed", scale = 1 / 3) +
  gg_density_layer(dist_normal(2, 1), linetype = "dashed", scale = 2 / 3)
}
\author{
Rob J Hyndman
}
