% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_as_array}
\alias{whapi_as_array}
\title{Ensure "messages" or "updates" input is always a list of objects}
\usage{
whapi_as_array(x, kind = c("message", "update"))
}
\arguments{
\item{x}{Input object: \code{NULL}, a list (single message/update), or a list of lists.}

\item{kind}{Either \code{"message"} or \code{"update"}. Defines which keys to look for when
deciding if input is a single object.}
}
\value{
A list of message/update objects (possibly length 0).
}
\description{
Utility to normalize webhook payloads so downstream parsers can safely \code{map_dfr()}.
Accepts single objects, arrays of objects, or \code{NULL}, and always returns a list.
}
\examples{
whapi_as_array(list(id="abc", type="text"), kind="message")
whapi_as_array(NULL, "update") # empty list

}
\keyword{internal}
