% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_redact}
\alias{whapi_redact}
\title{Redact sensitive values in headers/cookies}
\usage{
whapi_redact(name, value)
}
\arguments{
\item{name}{Header or cookie name (character).}

\item{value}{Header or cookie value (character).}
}
\value{
The original value, or \code{"<redacted>"} if the header is considered sensitive.
}
\description{
Replaces sensitive header or cookie values (e.g., \code{Authorization},
\code{Cookie}, \code{X-API-Key}) with the literal string \code{"<redacted>"}.
Useful when logging HTTP requests while avoiding credential leaks.
}
\examples{
whapi_redact("Authorization", "Bearer abc123")
whapi_redact("Content-Type", "application/json")
}
