% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis.R
\name{wbt_natural_neighbour_interpolation}
\alias{wbt_natural_neighbour_interpolation}
\title{Natural neighbour interpolation}
\usage{
wbt_natural_neighbour_interpolation(
  input,
  output,
  field = NULL,
  use_z = FALSE,
  cell_size = NULL,
  base = NULL,
  clip = TRUE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input vector points file.}

\item{output}{Output raster file.}

\item{field}{Input field name in attribute table.}

\item{use_z}{Use the 'z' dimension of the Shapefile's geometry instead of an attribute field?.}

\item{cell_size}{Optionally specified cell size of output raster. Not used when base raster is specified.}

\item{base}{Optionally specified input base raster file. Not used when a cell size is specified.}

\item{clip}{Clip the data to the convex hull of the points?.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates a raster grid based on Sibson's natural neighbour method.
}
\keyword{GISAnalysis}
