% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_USGS.R
\name{ww_wymUSGS}
\alias{ww_wymUSGS}
\title{Water Year & Monthly Stats (USGS)}
\usage{
ww_wymUSGS(procDV, sites = NULL, parallel = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{procDV}{A previously created \link[whitewater]{ww_dvUSGS} object.}

\item{sites}{A \code{character} vector with NWIS site numbers (optional).}

\item{parallel}{\code{logical} indicating whether to use future_map().}

\item{verbose}{\code{logical} for printing information. TRUE (default).}

\item{...}{arguments to pass on to \link[furrr]{future_map} and \link[whitewater]{ww_dvUSGS}.}
}
\value{
A \code{tibble} filtered by water year and month with added meta-data.
}
\description{
This function uses the results of the \link[whitewater]{ww_dvUSGS} object to
generate mean, maximum, median, standard deviation and coefficient of variation
per water year per month.
}
\note{
If a previously created \link[whitewater]{ww_dvUSGS} object is not used then the user needs to
provide a \code{sites} vector. This will run \link[whitewater]{ww_dvUSGS} in the background.
}
\examples{
\dontrun{

library(whitewater)
yaak_river_dv <- ww_dvUSGS('12304500',
parameter_cd = '00060',
wy_month = 10)

yaak_river_wym <- ww_wymUSGS(yaak_river_dv)

}

}
