% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init-library.R
\name{winch_init_library}
\alias{winch_init_library}
\title{Set library to collect symbols for native stack traces}
\usage{
winch_init_library(path = NULL, force = FALSE)
}
\arguments{
\item{path}{Path to the DLL.}

\item{force}{Reinitialize even if the path to the DLL is unchanged
from the last call.}
}
\value{
This function is called for its side effects.
}
\description{
On Windows, function names in native stack traces can be obtained
for only one library at a time.
Call this function to set the library for which to obtain symbols.
}
\examples{
\dontshow{if (requireNamespace("rlang", quietly = TRUE)) withAutoprint(\{ # examplesIf}
winch_init_library(getLoadedDLLs()[["rlang"]][["path"]])
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=winch_call]{winch_call()}}
}
