% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{notify_synthetic}
\alias{notify_synthetic}
\title{Notify the user when synthetic data are being used}
\usage{
notify_synthetic(..., msg = NULL, worcs_directory = ".")
}
\arguments{
\item{...}{Objects of class \code{worcs_data}. The function will check if
these are original or synthetic data.}

\item{msg}{Expression containing the message to print in case not all
\code{worcs_data} are original.}

\item{worcs_directory}{Character, indicating the WORCS project directory to
which to save data. The default value \code{"."} points to the current
directory.}
}
\value{
No return value. This function is called for its side effect of
printing a notification message.
}
\description{
This function prints a notification message when some or all of
the data used in a project are synthetic (see \code{\link{closed_data}} and
\code{\link{synthetic}}). See details for important information.
}
\details{
The preferred way to use this function is to provide specific data
objects in the function call, using the \code{...} argument.
If no such objects are provided, \code{notify_synthetic} will scan the
parent environment for objects of class \code{worcs_data}.

This function is emphatically designed to be included in an 'R Markdown'
file, to dynamically generate a notification message when a third party
'Knits' such a document without having access to all original data.
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
  withr::with_tempdir({
    file.create(".worcs")
    df <- iris
    class(df) <- c("worcs_data", class(df))
    attr(df, "type") <- "synthetic"
    result <- capture.output(notify_synthetic(df, msg = "it is synthetic"))
    if(!grepl("synthetic", result)) stop()
    df <- df[1:10, ]
    closed_data(df, codebook = NULL)
    file.remove("df.csv")
    result <- capture.output(notify_synthetic(msg = "synthetic"))
    if(!grepl("synthetic", result)) stop()
    if(requireNamespace("rmarkdown", quietly = TRUE)){
    add_manuscript(manuscript = "github_document")
    print(readLines("manuscript/manuscript.Rmd"))
    rmarkdown::render("manuscript/manuscript.Rmd")
    if(!any(grepl("reproduced using synthetic",
    readLines("manuscript/manuscript.html")))) stop()
    }
  })
}
}
\seealso{
closed_data synthetic add_synthetic
}
