% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordler.R
\name{assess_guess}
\alias{assess_guess}
\title{Assess a guess against the target word}
\usage{
assess_guess(game)
}
\arguments{
\item{game}{'wordler' game object (as generated by
\code{\link{new_wordler}}).}
}
\value{
'wordler' game object.
}
\description{
Assesses the guess in list \code{game$guess} (index from
\code{game$guess_count}) against the target word in \code{game$target}.
}
\details{
Adds the assessment to the corresponding list item in \code{game$assess}.
This assessment should be considered as how the guesses should be displayed
to the user and replicates the behaviour of the WORDLE game
(\url{https://www.powerlanguage.co.uk/wordle/}).

For each letter in each guess, one of the following assessments are made:
 \itemize{
  \item 'not_in_word' - the letter is not present in the target word (or has
  already been flagged as 'in_word' earlier in the word).
  \item 'in_word' - the letter is in the target word. More specifically,
  the first instance of the letter in the guess present in the word.
  Subsequent instances are flagged as 'not_in_word'.
  \item 'in_position' - the letter is in the same position in the target
  word.
}
}
