% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{option_add}
\alias{option_add}
\alias{option_remove}
\alias{option_add_parameters}
\title{Add and edit options saved in a workflow set}
\usage{
option_add(x, ..., id = NULL, strict = FALSE)

option_remove(x, ...)

option_add_parameters(x, id = NULL, strict = FALSE)
}
\arguments{
\item{x}{A workflow set outputted by \code{\link[=workflow_set]{workflow_set()}} or \code{\link[=workflow_map]{workflow_map()}}.}

\item{...}{Arguments to pass to the \verb{tune_*()} functions (e.g.
\code{\link[tune:tune_grid]{tune::tune_grid()}}) or \code{\link[tune:fit_resamples]{tune::fit_resamples()}}. For \code{option_remove()} this
can be a series of unquoted option names.}

\item{id}{A character string of one or more values from the \code{wflow_id}
column that indicates which options to update. By default, all workflows
are updated.}

\item{strict}{A logical; should execution stop if existing options are being
replaced?}
}
\value{
An updated workflow set.
}
\description{
The \code{option} column controls options for the functions that are used to
\emph{evaluate} the workflow set, such as \code{\link[tune:fit_resamples]{tune::fit_resamples()}} or
\code{\link[tune:tune_grid]{tune::tune_grid()}}. Examples of common options to set for these functions
include \code{param_info} and \code{grid}.

These functions are helpful for manipulating the information in the \code{option}
column.
}
\details{
\code{option_add()} is used to update all of the options in a workflow set.

\code{option_remove()} will eliminate specific options across rows.

\code{option_add_parameters()} adds a parameter object to the \code{option} column
(if parameters are being tuned).

Note that executing a function on the workflow set, such as \code{tune_grid()},
will add any options given to that function to the \code{option} column.

These functions do \emph{not} control options for the individual workflows, such as
the recipe blueprint. When creating a workflow manually, use
\code{\link[workflows:add_model]{workflows::add_model()}} or \code{\link[workflows:add_recipe]{workflows::add_recipe()}} to specify
extra options. To alter these in a workflow set, use
\code{\link[=update_workflow_model]{update_workflow_model()}} or \code{\link[=update_workflow_recipe]{update_workflow_recipe()}}.
}
\examples{
library(tune)

two_class_set

two_class_set |>
  option_add(grid = 10)

two_class_set |>
  option_add(grid = 10) |>
  option_add(grid = 50, id = "none_cart")

two_class_set |>
  option_add_parameters()
}
