% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{store_dataset}
\alias{store_dataset}
\title{Store a dataset into a workspace}
\usage{
store_dataset(
  x,
  dataset,
  name,
  timestamp = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S")
)
}
\arguments{
\item{x}{the workspace object}

\item{dataset}{the data.frame or sf to store in the workspace.}

\item{name}{name associated with the data.frame, if a workspace file with this name exists
already it will be replaced. The name is translated to ascii using
\code{\link[stringi:stri_trans_general]{stringi::stri_trans_general()}} to avoid file naming issues.}

\item{timestamp}{A timestamp string to associate with the entry in the workspace.}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Store a dataset in an existing workspace. The file format used depends on the
class of dataset.
\itemize{
\item \code{data.frame} is written as a Parquet using the \code{arrow} package.
\item \code{sf} is written as a geopackage file (.gpkg) using the \code{sf} package.
\item \code{splatRaster} is written as a TIFF file (.tiff) format using \code{terra} package.
}
}
\section{Geospatial data}{


To store raster data, ensure  that \code{terra} is installed. To store geospatial vector
and polygon data, ensure that \code{sf} is installed.

Storing geospatial vector and polygon data will also create an accompanying
metadata yaml file in the \verb{assets/sf_metadata/\{name\}.yaml} location,
containing metadata for when the file is read.
}

\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
z
}
\seealso{
\link{workspace} for package documentation

Other functions to write in a workspace: 
\code{\link{delete_dataset}()},
\code{\link{store_json}()},
\code{\link{store_raster}()},
\code{\link{store_rds}()},
\code{\link{store_yaml}()}
}
\concept{functions to write in a workspace}
