% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_dataset_in_workspace}
\alias{read_dataset_in_workspace}
\title{Read a Table from a Workspace.}
\usage{
read_dataset_in_workspace(x, name)
}
\arguments{
\item{x}{the workspace}

\item{name}{name of the dataset stored in the workspace}
}
\value{
A \code{tibble} if the dataset is stored as parquet, and a
\code{sf} object if it is stored as a geospatial dataset
(see \code{\link[=store_dataset]{store_dataset()}} for details).
}
\description{
Read a table from a dataset stored as parquet file
in a workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
read_dataset_in_workspace(z, name = "mtcars")
}
\seealso{
\link{workspace} for package documentation

Other functions to read in a workspace: 
\code{\link{list_object_in_workspace}()},
\code{\link{read_json_str_in_workspace}()},
\code{\link{read_raster_in_workspace}()},
\code{\link{read_rds_in_workspace}()},
\code{\link{read_timestamp}()},
\code{\link{read_yaml_in_workspace}()}
}
\concept{functions to read in a workspace}
