% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_prdseries.R
\name{show_prdseries}
\alias{show_prdseries}
\title{Plot predictions for GAMs over time series}
\usage{
show_prdseries(
  mod,
  ylab,
  yromit = NULL,
  alpha = 0.7,
  base_size = 11,
  xlim = NULL,
  ylim = NULL,
  col = "brown"
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{ylab}{chr string for y-axis label}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}

\item{alpha}{numeric from 0 to 1 indicating line transparency}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}

\item{col}{optional chr string for line color}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot predictions for GAMs over time series
}
\details{
The optional \code{yromit} vector can be used to omit years from the plot. This may be preferred if the predicted values from the model deviate substantially from other years likely due to missing data.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl')

mod <- anlz_gam(tomod, trans = 'log10')

show_prdseries(mod, ylab = 'Chlorophyll-a (ug/L)')
}
\concept{show}
