% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowSEMs.R
\name{rowSEMs}
\alias{rowSEMs}
\title{SEM for each row}
\usage{
rowSEMs(dat)
}
\arguments{
\item{dat}{matrix or data.frame}
}
\value{
This function returns a numeric vector with SEM values
}
\description{
This function speed optimized SEM (standard error of the mean) for each row.
The function takes a matrix or data.frame and treats each row as set of data for SEM; NAs are ignored from data.
Note: NaN instances will be transformed to NA
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
head(rowSEMs(dat1))
}
\seealso{
\code{\link{rowSds}},  \code{\link{colSds}}, \code{\link[base]{colSums}}
}
