% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreFragments.R
\name{scoreFragments}
\alias{scoreFragments}
\title{Scoring For Single Protein : Individual Components}
\usage{
scoreFragments(
  resTab,
  fragmInp,
  suplTakeLog = TRUE,
  j = NULL,
  useResCol = c("orig", "seq", "precAA", "tailAA", "beg", "end", "ppmToPred", "obsInd",
    "predInd", "Abundance"),
  prefFragPat = NULL,
  contigTermFragWe = 0.5,
  figDraw = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{resTab}{(matrix or data.frame) matrix or data.frame of results for SINGLE protein (will use columns 'beg','end','orig','obsInd')}

\item{fragmInp}{(matrix) experimental m/z values including suppl col(s) to be considered for score, its intensity column/value will be used for 'logInt' in output}

\item{suplTakeLog}{(logical) if suppl info should be used as log2: if T all supplemental data columns ('fragmInp') will be taken as log2}

\item{j}{(integer) which column of fragmInp has m/z values, the following column is assumed as peak-intensity}

\item{useResCol}{(character) column-names from resTab to be used}

\item{prefFragPat}{(matrix) for preferential fragmentation rules (see \code{.prefFragPattern()})}

\item{contigTermFragWe}{(numeric, length=1) weight to add for terminal fragments at 'sc.complemFra' (since they cannot match other fragments beyond the protein limits)}

\item{figDraw}{(logical) make additional figure}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages and objects exportet to current session for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list with matrix $scaled (combined and indiv rescaled scores) and $raw (matching lines of 'resTab'; 'index' refers to predictedIndex)
}
\description{
Make scoring for single protein : individual components :sameSite,contiguous,prefFragSite,logPeakHeight + combined (sum of scales 0->1)
}
\examples{
tab2 <- matrix(c("20","2","13","11","3","10","4", "PT","PE","EP","DE","PEP","IDE","PEPT", 
  rep(c("PEPTIDE","protP"),each=7), c("inter","Nter","Cter")[c(1,2,1,3,2,3,2)], 
  c(3,1,2,6,1,5,1, 4,2,3,7,3,7,4), "E",NA,"P","I",NA,"T",NA, "I","P","T",NA,"T",NA,"I", 
  c(1,6,6,20,7,19,8), c(-0.094312,-0.14707,-0.14707,0.08641,0.0084762,-0.10965,0.057087), 
  rep(2,7)), nrow=7, dimnames=list(NULL,c("predInd","seq","orig","origNa","ty","beg","end",
  "precAA","tailAA","obsInd","ppmToPred","mass")))
tab2 <- cbind(tab2, seqNa=paste0(tab2[,"origNa"],".",tab2[,"beg"],"-",tab2[,"end"]),Abundance=1)
rownames(tab2) <- paste0(tab2[,"origNa"],".", tab2[,"beg"],"", tab2[,"end"])
obsMassX <- cbind(a=c(199.1077,296.1605,397.2082,510.2922,625.3192),
  b=c(227.1026,324.1554,425.2031,538.2871,653.3141),
  x=c(729.2937,600.2511,503.1984,402.1507,289.0666),
  y=c(703.3145,574.2719,477.2191,376.1714,263.0874))

(outF <- scoreFragments(tab2, fragmInp=cbind(as.numeric(obsMassX), Abundance=1)))

}
\seealso{
\code{\link{identifyPepFragments}}, \code{\link{scoreProteinFragments}}
}
