% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkModTy.R
\name{checkModTy}
\alias{checkModTy}
\title{Check & complete mixed of variable and fixed modifications}
\usage{
checkModTy(
  modTy,
  knownMods = NULL,
  silent = TRUE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{modTy}{(character) list of modification types to be considered}

\item{knownMods}{(character) optonal custom list of known modifications, default from \code{AAfragSettings(outTy="all")$knownMods}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns the corrected list of mixed of variable and fixed modifications ($basMod, $varMod and $varMo2)
}
\description{
Check & complete settings for mixed of variable and fixed modifications.
The final format is a list with $basMod, $varMod and $varMo2
}
\examples{
modTy1 <- list(basMod=c("b","y","h"),varMod=c("p","o","q"))
checkModTy(modTy1)
}
\seealso{
\code{\link{AAfragSettings}}
}
