% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentSeq.R
\name{.NtermPepCut}
\alias{.NtermPepCut}
\title{Make Named Character Vector Of Sequential C-Terminal Fragments}
\usage{
.NtermPepCut(
  pe,
  mi,
  se1 = ".",
  se2 = "-",
  mainName = NULL,
  sepNC = FALSE,
  indexOffs = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{pe}{(character, length=1) sequence to be cut in sequential way}

\item{mi}{(integer) min number of AA residues for considering peptide fragments; should be <= length(pe) (otherwise the full length of 'pe' ALWAYS returned !)}

\item{se1}{(character, length=1) separators for adding numbers to specify partial/fragment locations}

\item{se2}{(character, length=1) separators for adding numbers to specify partial/fragment locations}

\item{mainName}{(character, length=1)}

\item{sepNC}{(logical) if TRUE, separate fragments from both ends as $Nter & $Cter in list}

\item{indexOffs}{(logical) offset to add for custom numbering in names (numeric, length=1), ie '1' will already increase by +1}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a numeric vector with mass(es) and sequence in name(s)
}
\description{
Make named character vector of sequential C-terminal fragments.
}
\examples{
## Ubiquitin example
P0CG48 <- "MQIFVKTLTGKTITLEVEPSDTIENVKAKIQDKEGIPPDQQRLIFAGKQLEDGRTLSDYNIQKESTLHLVLRLRGG"  
cut1 <- .CtermPepCut(P0CG48, mi=3, mainName="P0CG48")
head(cut1); tail(cut1)
#' @export
}
\seealso{
more flexible/sophisticated see \code{\link{.termPepCut}}; \code{\link{makeFragments}}; \code{\link[wrProteo]{convAASeq2mass}}
}
