% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifVarModif.R
\name{identifVarModif}
\alias{identifVarModif}
\title{Idenitfy Variable Modifications}
\usage{
identifVarModif(
  zz,
  modTy,
  expMa,
  maxMod,
  identMeas = "ppm",
  knownMods = NULL,
  limitIdent = 5,
  filtAmbiguous = FALSE,
  indexStart = 1,
  recalibFact = NULL,
  suplPepTab = NULL,
  massTy = "mono",
  silent = FALSE,
  callFrom = NULL,
  debug = TRUE
)
}
\arguments{
\item{zz}{(list) min input, result from \code{identifFixedModif}, must conatain elements 'nmassMatch','preMa','pepTab','recalibFact','recalibData'}

\item{modTy}{(character) type of fixed and variable modifications}

\item{expMa}{(matrix) experimental m/z values}

\item{maxMod}{(integer) maximum number of residue modifications to be consiered in fragments (values >1 will increase complexity and RAM consumption)}

\item{identMeas}{(character) comparison type (used in findCloseMatch(), default ="ppm"), used with limit 'limitIdent'}

\item{knownMods}{(character) optional custom alternative to \code{AAfragSettings(ou="all")$knownMods}}

\item{limitIdent}{(integer) limit applied to 'identMeas'}

\item{filtAmbiguous}{(logical) toggle to remove all ambiguous identifications}

\item{indexStart}{(integer) for keeping correct index at iterative use}

\item{recalibFact}{(numeric, length=1)}

\item{suplPepTab}{(matrix) predicted fragments (incl fixed and var modifs) to include to search (allowong to ensure overlap to include hits close to prev search)}

\item{massTy}{(character) 'mono' or 'average'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
list with $massMatch (list of exerimental peptides matching to one or more predicted), $preMa (predicted ions, including fixed and variable modif),
 $pepTab (predicted neutral peptides, wo modifications), $expMa (experimental mass from input), $recalibFact (recalibration factor as from input), $docTi (time for calculations)
}
\description{
Take result from \code{identifFixedModif} and search for variable modifications (only on identified fixed modif), ie 2nd step for identif of var modifs.
To reduce the complexity of the search space, only peptide fragments identified with fixed identifiactions will be considered for possible variable modifications.
}
\details{
The main matching results are in output$massMatch : This list has one entry for each predicted mass where some matches were found. 
Thus, the names of the list-elements design the index from argument \code{expMass}. 
Each list-element contains a numeric vector giving the difference observed to predicted, the names design the unique predicted peptide index/number from output$preMa[,"no"]
}
\examples{
protP <- c(protP="PEPTIDE")
obsMassX <- cbind(a=c(199.1077,296.1605,397.2082,510.2922,625.3192),
  b=c(227.1026,324.1554,425.2031,538.2871,653.3141),
  x=c(729.2937,600.2511,503.1984,402.1507,289.0666),
  y=c(703.3145,574.2719,477.2191,376.1714,263.0874))
rownames(obsMassX) <- c("E","P","T","I","D")      # all 1 & 7 ions not included
identP10 <- identifFixedModif(prot=protP,expMass=as.numeric(obsMassX),minFragSize=2, 
  maxFragSize=7,modTy=list(basMod=c("b","y")))     # looks ok
identP10v <- identifVarModif(identP10,list(varMod="h"), as.numeric(obsMassX),2)
identP10v$massMatch                    # list of matches

}
\seealso{
\code{\link{makeFragments}}, \code{\link{identifFixedModif}}, \code{\link{identifyPepFragments}}
}
