% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countPotModifAAs.R
\name{.countModif}
\alias{.countModif}
\title{Count For All Proteins The Occurance Of Modification Types}
\usage{
.countModif(
  sequ,
  modTyp,
  specAAMod,
  knownMods,
  detailedCount = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{sequ}{(character) peptide sequence(s)}

\item{modTyp}{(list) modifications : $basMod for character vector of fixed modifications and $varMod for variable modifications. For one letter-code see AAfragSettings("modChem")}

\item{specAAMod}{(list) optional custom list showing which AA to be considered with which (one-letter) modification code (default \code{\link{AAfragSettings}})}

\item{knownMods}{(list) optional custom list showing which modification appears at what type of location, eg N-terminal, internal ... (default \code{\link{AAfragSettings}})}

\item{detailedCount}{(logical)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) for bug-tracking: more/enhanced messages and intermediate objects written in global name-space}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This function returns a list of matrixes $cou and $combTerm, with number of modifications per peptides (line in 'pepTab') for basMod, varMod & varMo2
}
\description{
Count for all protein 'sequ' the occurance of modification types defined in list 'modTyp' (only if in names(specAAMod)).
}
\examples{
protP2 <- c(mesp="MESPEPTIDES", pepe="PEPEPEP")
pepTab1 <- makeFragments(protTab=protP2, minFra=6, internFr=TRUE, massTy="mono")
modTy2 <- list(basMod=c("b","y","h"), varMod=c("x","p","o","q","e","j"))
.countModif(pepTab1[,2], modTyp=c("b","y"), specAAMod=AAfragSettings(outTy="all")$specAAMod, 
  knownMods=AAfragSettings(outTy="all")$knownMods)
}
\seealso{
\code{\link{AAfragSettings}}, \code{\link{makeFragments}}
}
