% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clin_estimates.R
\name{WINratio}
\alias{WINratio}
\title{Comparison for groups in clinical trials based on all possible combinations of subjects}
\usage{
WINratio(data, groupvar, testvars, rules, idvar = NULL, p_digits = 3)
}
\arguments{
\item{data}{name of data set (tibble/data.frame) to analyze.}

\item{groupvar}{name of grouping variable, has to translate to 2 groups.}

\item{testvars}{names of variables for sequential rules.}

\item{rules}{list of rules (minimal cut-offs) for sequential comparison, negative if reduction is success, positive if increase is beneficial, must not be 0.}

\item{idvar}{name of identifier variable. If NULL, rownumber is used.}

\item{p_digits}{level for rounding p-value.}
}
\value{
A list with elements:

WINratio=vector with WINratio and CIs,

WINodds=odds ratio of wins and losses, taking ties into account,

p.value=p.value from prop.test,

WINratioCI=character with merged WINratio, CI, and p

testdata= tibble with testdata from cross-join.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{WINratio} computes the ratio of wins and losses for any number
of comparison rules.
}
