% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_parameters.R
\name{sort_parameters}
\alias{sort_parameters}
\title{Sort Parameters for Printing in SEM Output}
\usage{
sort_parameters(df)
}
\arguments{
\item{df}{A data frame that contains a column named \code{Parameter} (e.g., from Monte Carlo CI output).}
}
\value{
A reordered version of the same data frame, with rows sorted according to
a predefined logical structure:
\enumerate{
\item a-paths (e.g., a1, a2, ...)
\item b-paths (e.g., b1, b2, ...)
\item d-paths (e.g., d1, d2, ...)
\item indirect effects (e.g., ind1, ind2, ...)
\item direct effect
\item total indirect
\item total effect
\item contrasts (e.g., ind1-ind2, ind2-ind3)
\item X-condition path terms (e.g., X1_b1, X0_b1, ...)
}
}
\description{
Sorts a parameter table by conceptual priority for presentation purposes.
This function is designed to support formatted output of mediation and SEM results
by organizing parameters such as a-paths, b-paths, indirect effects, contrasts, etc.
}
\details{
This is an internal helper function used by \code{print.WsMed()} to ensure that printed
tables of standardized or unstandardized estimates appear in a logical and human-readable order.
}
\keyword{internal}
