% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_tdiff_multivariate.r
\name{ws_tdiff_multivariate_general}
\alias{ws_tdiff_multivariate_general}
\title{Welch-Satterthwaite Approximation for General Multivariate t-Differences}
\usage{
ws_tdiff_multivariate_general(
  mu1,
  Sigma1,
  nu1,
  mu2,
  Sigma2,
  nu2,
  max_iter = 10,
  tol = 0.001
)
}
\arguments{
\item{mu1}{Location vector of first distribution (length p)}

\item{Sigma1}{Scale matrix of first distribution (p x p, positive definite)}

\item{nu1}{Degrees of freedom of first distribution (must be > 4)}

\item{mu2}{Location vector of second distribution (length p)}

\item{Sigma2}{Scale matrix of second distribution (p x p, positive definite)}

\item{nu2}{Degrees of freedom of second distribution (must be > 4)}

\item{max_iter}{Maximum iterations for convergence (default: 10)}

\item{tol}{Convergence tolerance (default: 1e-6)}
}
\value{
An S3 object of class "ws_tdiff_multivariate_general" containing:
  \item{mu_diff}{Location vector of difference}
  \item{Sigma_star}{Effective scale matrix}
  \item{nu_star}{Effective degrees of freedom (scalar)}
  \item{converged}{Logical indicating convergence}
  \item{iterations}{Number of iterations performed}
  \item{method}{Character string "multivariate_general"}
}
\description{
Approximates the distribution of differences between two independent
multivariate t-distributed random vectors with arbitrary covariance
structure. This implements Theorem 3 from Yamaguchi et al. (2025).
}
\details{
This function handles the general case where components may be correlated
within each multivariate t-distribution. The approximation uses a single
scalar degrees of freedom parameter to capture the overall tail behavior.

The iterative algorithm (Section 4.3 of the paper):
\enumerate{
  \item Initialize with sum of covariance matrices
  \item Compute effective degrees of freedom using trace formulas
  \item Update scale matrix
  \item Iterate until convergence
}

Note: For high dimensions with heterogeneous component behaviors,
consider using \code{\link{ws_tdiff_multivariate_independent}} instead.
}
\examples{
Sigma1 <- matrix(c(1, 0.3, 0.3, 1), 2, 2)
Sigma2 <- matrix(c(1.5, 0.5, 0.5, 1.2), 2, 2)
result <- ws_tdiff_multivariate_general(
  mu1 = c(0, 1), Sigma1 = Sigma1, nu1 = 10,
  mu2 = c(0, 0), Sigma2 = Sigma2, nu2 = 15
)
print(result)

}
