% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.diagnosis.R
\name{w.diagnosis}
\alias{w.diagnosis}
\title{W-test Probability Distribution Diagnostic Plot}
\usage{
w.diagnosis(data, w.order = c(1, 2), n.rep = 10,
  n.sample = nrow(data), n.marker = ncol(data), hf1 = "default.hf1",
  hf2 = "default.hf2", ...)
}
\arguments{
\item{data}{a data frame or matrix containing genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{w.order}{an integer value of 0 or 1. \code{w.order} = 1 gives main effect calculation; \code{w.order} = 2 gives pairwise calculation.}

\item{n.rep}{a numeric value, the number of bootstrapping times.}

\item{n.sample}{a numeric value, the number of samples to use in bootstrapping. Default is the total number of samples in the data.}

\item{n.marker}{a numeric value, the number of markers to use in bootstrapping. Default is the total number of markers.}

\item{hf1}{\emph{h} and \emph{f} values to calculate main effect, organized as a matrix, with columns (\emph{k}, \emph{h}, \emph{f}), \emph{k} = 2 to 3. Needed when \code{w.order} = 1.}

\item{hf2}{\emph{h} and \emph{f} values to calculate interaction associations, organized as a matrix, with columns (\emph{k}, \emph{h}, \emph{f}), \emph{k} = 2 to 9. Needed when \code{w.order} = 2.}

\item{...}{graphical parameters.}
}
\description{
Diagnostic checking of W-test probability distribution estimation.
}
\details{
{This function evaluates the input W values of main or interaction effects using a set of null Y by the \code{W-test}, and the evaluation is performed in several bootstrap samples to achieve fast and stable output. The W histogram and its theoretical Chi-squared distribution density with \emph{f} degrees of freedom are plotted indexed by \emph{k}. Close overlaying of the histogram and the probability density curve indicates that the estimated \emph{h} and \emph{f} give a good test statistic probability distribution.}
}
\examples{
data(diabetes.geno)
# Please note that parameter B is recommended to be greater than 400.
hf1 <- hf(data = diabetes.geno, w.order = 1, B = 100)
hf2 <- hf(data = diabetes.geno, w.order = 2, B = 50)
w.diagnosis(diabetes.geno, w.order = 1, n.rep = 100, hf1 = hf1, main=NULL, xlab=NULL, ylab=NULL)
w.diagnosis(diabetes.geno, w.order = 2, n.rep = 100, hf2 = hf2, main=NULL, xlab=NULL, ylab=NULL)
}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research. doi:10.1093/nar/gkw347.
}
\seealso{
\code{\link{wtest}}, \code{\link{hf}}, \code{\link{w.qqplot}}
}
\author{
Rui Sun, Maggie Haitian Wang
}
