% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{admix_barplot}
\alias{admix_barplot}
\title{Admixture Data Stacked Barplot}
\usage{
admix_barplot(
  data,
  K = 2:ncol(data),
  individuals = 1,
  sortkey = NULL,
  grouping = NULL,
  palette = "default",
  names = TRUE,
  xlab = "Individuals",
  ylab = "Ancestry",
  main = "Admixture Plot",
  noclip = FALSE
)
}
\arguments{
\item{data}{Data frame containing the admixture data.}

\item{K}{Positions of the columns containing the ancestry percentages in the provided data frame; default is second to last column.}

\item{individuals}{Position of the column with the names for the x-axis; default is the first column.}

\item{sortkey}{Name of the column containing ancestry percentages to sort the stacked barplot with.}

\item{grouping}{Name of the column by which the stacked bars are to be grouped.}

\item{palette}{Either a color palette object, or a string to use one of the predefined color palettes ("viridis", "turbo", "alternating"); default is a modified ggplot palette.}

\item{names}{Whether to show the x-axis bar labels or not; default is "TRUE".}

\item{xlab}{A label for the x-axis.}

\item{ylab}{A label for the y-axis.}

\item{main}{A main title for the plot.}

\item{noclip}{Directly draw the plot, with clipping removed from elements. Then function does not return an object; default is set to "FALSE". Setting to "TRUE" may require launching a new R graphics device.}
}
\value{
A ggplot object of the stacked barplot.
}
\description{
Stacked barplot optimized for admixture data.
}
\examples{
# load simulated admixture data
data("xadmixture")

# for data frame with ancestries (K) in fourth to last column,
# without showing bar labels
admix_barplot(xadmixture,
    K = 4:ncol(xadmixture),
    names = FALSE
)

# grouping data by column "country",
# and sorting each group by ancestry column "K1"
admix_barplot(xadmixture,
    K = 4:ncol(xadmixture),
    grouping = "country",
    sortkey = "K1",
    names = FALSE
)

# changing color palette to "turbo" from package 'viridis',
admix_barplot(xadmixture,
    K = 4:ncol(xadmixture),
    palette = "turbo",
    names = FALSE
)

# removing title and changing axis labels text
admix_barplot(xadmixture,
    K = 4:ncol(xadmixture),
    main = "",
    xlab = "Accessions",
    ylab = "Ancestry [\%]",
    names = FALSE
)

# directly output grouped plot with clipping removed from elements
# (useful if there are groups with a low number of observations)
# create a subset of the data
xadmixture_sub <- admix_subset(xadmixture,
                              anc = c("K3", "K4"), 
                              pct = c(0.3, 0.2))
# generate a grouped & sorted stacked barplot 
# setting "noclip" to "TRUE" may require opening a new graphics device
dev.new()
admix_barplot(xadmixture_sub, 
             K = 4:ncol(xadmixture),          
             sortkey = "K5",
             grouping = "country", 
             palette = "viridis", 
             names = FALSE, 
             noclip = TRUE)
dev.off()
}
