% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_logo.R
\name{logo}
\alias{logo}
\alias{use_logo}
\alias{html_dependency_logo}
\title{Add Logo}
\usage{
use_logo(
  image_url,
  width = "110px",
  height = "128px",
  position = css_position(top = "1em", right = "1em"),
  link_url = NULL,
  exclude_class = c("title-slide", "inverse", "hide_logo")
)

html_dependency_logo(
  link_url = NULL,
  exclude_class = c("title-slide", "inverse", "hide_logo"),
  inline = NULL
)
}
\arguments{
\item{image_url}{The URL to the image file of your logo. In general, either
a full URL or the path to the image relative to your slides file.}

\item{width}{Width in CSS units of the logo}

\item{height}{Height in CSS units of the logo}

\item{position}{The position of the logo from the sides of the slide. Use
\code{\link[=css_position]{css_position()}} to specify.}

\item{link_url}{Optional. If provided, your logo becomes a clickable link.}

\item{exclude_class}{The slide classes that should not receive the logo. By
default, the title slide, inverse slides and slides with the \code{hide_logo}
class are excluded.}

\item{inline}{In \code{\link[=html_dependency_logo]{html_dependency_logo()}}, should the JS and CSS code to
create the logo be returned inline (inside the rendered slides) or in
separate CSS and JS documents attached as an html dependency? The default
is to use inline for \pkg{xaringan} version 0.16 or later.}
}
\value{
An \code{htmltools::tagList()} with the Add Logo dependencies, or an
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.
}
\description{
\code{use_logo()} adds a logo to all of your slides. You can make the logo a
clickable link and choose where on the page it is placed. You can also set
which types of slides will not get the logo by default.
}
\section{Functions}{
\itemize{
\item \code{use_logo()}: Adds logo to your xaringan slides.

\item \code{html_dependency_logo()}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the tile
view dependencies. Most users will want to use \code{use_logo()}.

}}
\section{Usage}{
 To add a logo to your xaringan presentation, add the
following code chunk to your slides' R Markdown file.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r xaringan-logo, echo=FALSE\}
xaringanExtra::use_logo(
  image_url = "https://raw.githubusercontent.com/rstudio/hex-stickers/master/PNG/xaringan.png"
)
```
}\if{html}{\out{</div>}}

See the documentation for \code{?use_logo} for more options regarding sizing
and positioning. You can also make the logo a link using \code{link_url} and
you can hide the logo for a particular slide by using the \code{hide_logo}
slide class.
}

\examples{
xaringan_logo <- file.path(
  "https://raw.githubusercontent.com/rstudio/hex-stickers/master",
  "PNG/xaringan.png"
)
use_logo(xaringan_logo)

}
