% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search}
\alias{search}
\alias{use_search}
\alias{html_dependency_search}
\alias{style_search}
\title{Search}
\usage{
use_search(
  position = c("bottom-left", "bottom-right", "top-left", "top-right"),
  case_sensitive = FALSE,
  show_icon = FALSE,
  auto_search = TRUE
)

html_dependency_search(
  position = c("bottom-left", "bottom-right", "top-left", "top-right"),
  case_sensitive = FALSE,
  show_icon = FALSE,
  auto_search = TRUE
)

style_search(
  icon_fill = "rgba(128, 128, 128, 0.5)",
  input_background = "rgb(204, 204, 204)",
  input_foreground = "black",
  input_border = "1px solid rgb(249, 38, 114)",
  match_background = "rgb(38, 220, 249)",
  match_foreground = "black",
  match_current_background = "rgb(38, 249, 68)",
  match_current_foreground = "black",
  selector = ".search"
)
}
\arguments{
\item{position}{Where to place the search box.}

\item{case_sensitive}{If \code{FALSE}, ignores case of search and text.}

\item{show_icon}{Show the icon to open or close the search?}

\item{auto_search}{Search on each keystroke (\code{TRUE}) or on enter (\code{FALSE})?}

\item{icon_fill}{Color of search icon}

\item{input_background}{Color of search input box background}

\item{input_foreground}{Color of text in search input box}

\item{input_border}{Border style of search input box}

\item{match_background}{Color of match background (not current)}

\item{match_foreground}{Color of match text (not current)}

\item{match_current_background}{Color of current match background}

\item{match_current_foreground}{Color of current match text}

\item{selector}{CSS selector specifying which search bar to update (for
advanced or unusual uses only)}
}
\value{
An \code{htmltools::tagList()} with the search dependencies, or an
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.
}
\description{
Search gives you a way to quickly search for text on slides.
}
\section{Functions}{
\itemize{
\item \code{use_search()}: Adds search to your xaringan slides.

\item \code{html_dependency_search()}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the search
dependencies. Most users will want to use \code{use_search()}.

\item \code{style_search()}: Style the search input.

}}
\section{Usage}{
 To add search to your xaringan presentation, add the
following code chunk to your slides' R Markdown file.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r xaringan-search, echo=FALSE\}
xaringanExtra::use_search()
```
}\if{html}{\out{</div>}}
}

\examples{
use_search()

}
\references{
\url{https://github.com/arestivo/remark.search}
}
\author{
Original implementation by André Restivo
}
