% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeLeaves}
\alias{treeLeaves}
\title{Measures the number of leaves of a complete derivation tree.}
\usage{
treeLeaves(tree, ST)
}
\arguments{
\item{tree}{Derivation tree.}

\item{ST}{Symbol table.}
}
\value{
Integer. Number of terminal symbols in a complete derivation tree.
}
\description{
\code{treeLeaves()} returns 
             the number of terminal symbols in a 
             complete derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
treeLeaves(a, g$ST) 
((treeLeaves(a, g$ST)+treeNodes(a, g$ST)) == treeSize(a))

}
\seealso{
Other Measures of Tree Attributes: 
\code{\link{treeListDepth}()},
\code{\link{treeNodes}()},
\code{\link{treeProbability}()},
\code{\link{treeSize}()}
}
\concept{Measures of Tree Attributes}
