% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeSize}
\alias{treeSize}
\title{Measures the number of symbols in a derivation tree.}
\usage{
treeSize(tree)
}
\arguments{
\item{tree}{Derivation tree.}
}
\value{
Integer. Number of symbols in a derivation tree.
}
\description{
\code{treeSize()} returns the number of symbols in a 
             derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
treeSize(a) 

}
\seealso{
Other Measures of Tree Attributes: 
\code{\link{treeLeaves}()},
\code{\link{treeListDepth}()},
\code{\link{treeNodes}()},
\code{\link{treeProbability}()}
}
\concept{Measures of Tree Attributes}
