% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeANL}
\alias{treeANL}
\title{Builds an Attributed Node List (ANL) of a derivation tree.}
\usage{
treeANL(
  tree,
  ST,
  maxdepth = 5,
  ANL = list(),
  IL = list(),
  count = 1,
  depth = 1
)
}
\arguments{
\item{tree}{A derivation tree.}

\item{ST}{A symbol table.}

\item{maxdepth}{Limit on the depth of a derivation tree.}

\item{ANL}{Attributed node list (empty on invocation).}

\item{IL}{Index function list  (empty on invocation).}

\item{count}{Trail count (1 on invocation).}

\item{depth}{Derivation tree depth (1 on invocation).}
}
\value{
A list with three elements:
        \enumerate{
        \item \code{$count}: The trail length (not needed).
        \item \code{$subtreedepth}: The derivation tree depth (not needed).
        \item \code{$ANL}:   The attributed node list is a list of nodes.
          Each node is represented as a list of the following attributes:
        \itemize{
        \item \code{Node$ID}:  Id in the symbol table ST.
        \item \code{Node$NonTerminal}:  Is the symbol a non-terminal?
        \item \code{Node$Pos}: Position in the trail.
        \item \code{Node$Depth}:  Depth of node.
        \item \code{Node$Rdepth}: Residual depth for expansion.
        \item \code{Node$subtreedepth}: Depth of subtree starting here.
        \item \code{Node$Index}:  R index of the node in the derivation tree.
                           Allows fast tree extraction and insertion.
        } 
                       
        }
}
\description{
\code{treeANL()} recursively traverses a derivation tree
    and collects information about the derivation tree in an attributed
    node list (ANL).
}
\details{
An attributed \code{node} has the following elements:
    \itemize{
        \item \code{$ID}:  Id in the symbol table \code{ST}.
        \item \code{$NonTerminal}:  Is the symbol a non-terminal?
        \item \code{$Pos}: Position in the trail.
        \item \code{$Depth}:  Depth of node.
        \item \code{$Rdepth}: Residual depth for expansion.
        \item \code{$subtreedepth}: Depth of subtree starting here.
        \item \code{$Index}:  R index of the node in the derivation tree.
                           Allows fast tree extraction and insertion.
       }
   These elements can be used e.g. 
   \itemize{
       \item for inserting and extracting subtrees 
       (\code{Pos} or  \code{node$Index}), 
       \item for checking
             the feasibility of subtree substitution (\code{ID}),
       \item for checking depth bounds 
             (\code{Depth}, \code{RDepth}, and \code{subtreedepth}),
             \dots
       }
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
b<-treeANL(a, g$ST)
c<-treeANL(a, g$ST, 10)
d<-treeANL(a, g$ST, maxdepth=10)

}
\seealso{
Other Access Tree Parts: 
\code{\link{filterANL}()},
\code{\link{filterANLid}()},
\code{\link{treeChildren}()},
\code{\link{treeRoot}()}
}
\concept{Access Tree Parts}
