% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaCrossover.R
\name{xegaGaUPCross2Gene}
\alias{xegaGaUPCross2Gene}
\title{Parameterized uniform crossover of 2 genes.}
\usage{
xegaGaUPCross2Gene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{A binary gene.}

\item{gg2}{A binary gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of 2 binary genes.
}
\description{
\code{xegaGaUP2CrossGene()} swaps alleles of both genes
             with a probability of \code{lF$UCrossSwap()}. 
             It generates a random 
             mask which is used to build the new gene.
             It returns 2  genes.
}
\examples{
gene1<-xegaGaInitGene(lFxegaGaGene)
gene2<-xegaGaInitGene(lFxegaGaGene)
xegaGaDecodeGene(gene1, lFxegaGaGene)
xegaGaDecodeGene(gene2, lFxegaGaGene)
newgenes<-xegaGaUPCross2Gene(gene1, gene2, lFxegaGaGene)
xegaGaDecodeGene(newgenes[[1]], lFxegaGaGene)
xegaGaDecodeGene(newgenes[[2]], lFxegaGaGene)
}
\references{
Spears William and De Jong, Kenneth (1991):
  On the Virtues of Parametrized Uniform Crossover. 
  In: Belew, Richar K. and Booker, Lashon B. (Ed.)
  Proceedings of the Fourth International Conference on Genetic Algorithms,
  Morgan Kaufmann Publishers, Los Altos, California, pp. 230-236.
  (ISBN:1-55860-208-9)
}
\seealso{
Other Crossover (Returns 2 Kids): 
\code{\link{xegaGaCross2Gene}()},
\code{\link{xegaGaUCross2Gene}()}
}
\concept{Crossover (Returns 2 Kids)}
