% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newCrossMutPipelineG}
\alias{newCrossMutPipelineG}
\title{Converts a gene into a gene with embedded genetic operator pipeline  with crossover and mutation (a function closure).}
\usage{
newCrossMutPipelineG(g, g1)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline 
        with mutation and crossover.
        The argument \code{lF} of the function \code{$Pipeline()} 
        configures the behavior of the pipeline.
}
\description{
The embedded pipeline is \code{evaluate(accept((crossover o mutation), gene, gene1))}.
             The symbol \code{o} is short for \code{mutation(crossover(gene, gene1))}
             in the accept function.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$BitMutationRate1<-function(fit, lF) {0.2}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {OperatorPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCrossMutPipelineG(g, g1)
print(a)
a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newMutPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
